/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmc.search;

import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hits;
import org.eclipse.epf.web.search.IndexLoader;
import org.eclipse.epf.web.search.IndexSearch;
import org.eclipse.epf.web.search.SearchResources;
import org.eclipse.epf.web.search.utils.UNCUtil;
import org.eclipse.epf.web.search.utils.XMLUtil;
import org.eclipse.epf.web.search.utils.XSLTProcessor;

public class SearchApplet
extends Applet {
    private static final int DEFAULT_HITS_PER_PAGE = 10;
    private static final long serialVersionUID = 1L;
    private static String _documentBase = null;
    private static String _indexPath = null;
    private static String _siteFolderName = null;
    private static String _xslURLEncode;
    private static String _xslURL;
    private static String _pathDocumentBase;
    private int _hitsPerPage = 10;
    private String _currentSearchString;
    private String _queryString;
    private Hits _hits;
    private int _numHits;
    private int _currentPage;
    private String analyzerName;
    public static final Pattern p_url_decoder;
    public static final String EMPTY_HTML = "<html></html>";
    private Properties xslParams = null;
    private JSObject jso = null;
    private static final String JS_METHOD_NAME = "updateSearchProgress";
    private static final String JS_METHOD_NAME2 = "initializedOk";
    private static final String SEARCH_STATUS_INITIALIZE_START = "s0";
    private static final String SEARCH_STATUS_INITIALIZE_END = "s1";
    private static final String SEARCH_STATUS_SEARCH_START = "s2";
    private static final String SEARCH_STATUS_SEARCH_QUERYING = "s3";
    private static final String SEARCH_STATUS_SEARCH_END = "s4";

    static {
        p_url_decoder = Pattern.compile("(<[^>]*?(src|href)\\s*=\\s*\")(.*?)(\"[^>]*?>)", 34);
    }

    public static String decodeUrlsInContent(String content) {
        try {
            StringBuffer sb = new StringBuffer();
            Matcher m = p_url_decoder.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                url = URLDecoder.decode(url, "UTF-8");
                String text = String.valueOf(m.group(1)) + url + m.group(4);
                m.appendReplacement(sb, text);
            }
            m.appendTail(sb);
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        SearchApplet searchApplet = this;
        synchronized (searchApplet) {
            try {
                this.jso = JSObject.getWindow((Applet)this);
                System.out.println("com.ibm.rmc.search.SearchApplet.init() ...");
                if (_documentBase != null && _siteFolderName != null) {
                    return;
                }
                this.updateProcess(SEARCH_STATUS_INITIALIZE_START);
                System.out.println("getDocumentBase():" + this.getDocumentBase());
                if (this.getDocumentBase() != null) {
                    _documentBase = this.getDocumentBase().toString();
                    int paraIdx = this.getDocumentBase().toString().indexOf("#");
                    if (paraIdx < 0) {
                        paraIdx = this.getDocumentBase().toString().indexOf("?");
                    }
                    if (paraIdx >= 0) {
                        _documentBase = _documentBase.substring(0, paraIdx);
                    }
                    _pathDocumentBase = _documentBase.substring(0, _documentBase.lastIndexOf("/"));
                    System.out.println("documentBase:" + _documentBase);
                } else {
                    System.out.println("getDocumentBase():=null");
                    Class<?> clazz = this.getClass();
                    System.out.println("class:" + clazz);
                    ClassLoader cl = clazz.getClassLoader();
                    System.out.println("classLoader:" + cl);
                    URL jarURL = cl.getResource("dectectingpathforappletsearch");
                    System.out.println("jarURL:" + jarURL);
                    String jarPathString = jarURL.toString();
                    jarPathString = jarPathString.substring(4, jarPathString.lastIndexOf("/"));
                    System.out.println("jarPathString - 1:" + jarPathString);
                    jarPathString = jarPathString.substring(0, jarPathString.lastIndexOf("/"));
                    System.out.println("jarPathString - 2: " + jarPathString);
                    _pathDocumentBase = jarPathString.substring(0, jarPathString.lastIndexOf("/"));
                }
                System.out.println("SearchApplet initialized - docbase:" + _pathDocumentBase);
                String index_dir = System.getProperty("search.index");
                StringBuffer indexFile = new StringBuffer();
                if (index_dir == null || index_dir.length() < 1) {
                    indexFile.append(System.getProperty("user.home"));
                } else {
                    indexFile.append(index_dir);
                }
                indexFile.append(File.separator).append("ibm").append(File.separator).append("process").append(File.separator);
                String indexPath = indexFile.toString();
                indexFile.append("index.jar");
                System.out.println("SearchApplet initialized - index file:" + indexFile);
                IndexLoader loader = new IndexLoader(_pathDocumentBase, indexPath, indexFile.toString());
                _siteFolderName = loader.checkIndexVersion();
                this.analyzerName = IndexLoader.getAnalyzerName();
                if (_siteFolderName == null) {
                    _siteFolderName = loader.downloadIndex();
                }
                _indexPath = loader.getUserIndexPath();
                loader = null;
                _xslURLEncode = String.valueOf(_pathDocumentBase) + "/search/";
                _xslURL = String.valueOf(URLDecoder.decode(_pathDocumentBase, "utf-8")) + "/search/";
                this.updateProcess(SEARCH_STATUS_INITIALIZE_END);
                this.initializedOk();
                System.out.println("siteFolderName: " + _siteFolderName);
                System.out.println("indexPath: " + _indexPath);
                System.out.println("pathDocumentBase: " + _pathDocumentBase);
                System.out.println("xslURL: " + _xslURL);
                System.out.println("com.ibm.rmc.search.SearchApplet.init() ... done");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateProcess(String status) {
        if (this.jso == null || status == null) {
            return;
        }
        try {
            JSObject theWidget;
            JSObject theApp = (JSObject)this.jso.getMember("theApp");
            if (theApp != null && (theWidget = (JSObject)theApp.getMember("searchWidget")) != null) {
                theWidget.call(JS_METHOD_NAME, status);
            }
        }
        catch (JSException e) {
            e.printStackTrace();
        }
    }

    private void initializedOk() {
        if (this.jso == null) {
            return;
        }
        try {
            JSObject theWidget;
            JSObject theApp = (JSObject)this.jso.getMember("theApp");
            if (theApp != null && (theWidget = (JSObject)theApp.getMember("searchWidget")) != null) {
                theWidget.call(JS_METHOD_NAME2, null);
            }
        }
        catch (JSException e) {
            e.printStackTrace();
        }
    }

    public String runSearch(String searchString, String resultsPerPage) {
        this.updateProcess(SEARCH_STATUS_SEARCH_START);
        if (resultsPerPage != null && resultsPerPage.length() > 0) {
            try {
                int hitsPerPage = Integer.parseInt(resultsPerPage);
                hitsPerPage = hitsPerPage > 0 ? hitsPerPage : 10;
                return this.runSearch(searchString, hitsPerPage);
            }
            catch (NumberFormatException nfe) {
                return EMPTY_HTML;
            }
        }
        return EMPTY_HTML;
    }

    public String runSearch(final String searchString, int hitsPerPage) {
        System.out.println("com.ibm.rmc.search.SearchApplet.runSearch: " + searchString);
        this._hitsPerPage = hitsPerPage < 10 ? 10 : hitsPerPage;
        try {
            String searchResultHTML = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SearchApplet.this._queryString = searchString;
                    SearchApplet.this._currentSearchString = IndexSearch.detectHyphenated((String)SearchApplet.this._queryString);
                    if (SearchApplet.this._currentSearchString.length() == 0) {
                        return SearchApplet.EMPTY_HTML;
                    }
                    boolean safe = SearchApplet.this.runQuery("contents");
                    String result = SearchApplet.this.updateOutput(safe);
                    return result == null ? SearchApplet.EMPTY_HTML : result;
                }
            });
            return searchResultHTML;
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_HTML;
        }
    }

    private boolean runQuery(String searchField) {
        this.updateProcess(SEARCH_STATUS_SEARCH_QUERYING);
        boolean result = false;
        try {
            this._hits = IndexSearch.search((String)_indexPath, (String)this._currentSearchString, (String)searchField, (String)this.analyzerName);
            if (this._hits != null) {
                this._numHits = this._hits.length();
                result = true;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this._numHits = 0;
            this._hits = null;
        }
        this._currentPage = 0;
        return result;
    }

    private String updateOutput(boolean safe) {
        String output = null;
        if (safe) {
            output = this.generateOutput(this._numHits, this._currentPage);
        } else {
            this._hits = null;
        }
        return output;
    }

    private String generateOutput(int numHits, int pageNum) {
        boolean prevEnabled;
        System.out.println("generateOutput: " + numHits + " & " + pageNum);
        int init = pageNum * this._hitsPerPage;
        int max = Math.min(numHits, init + this._hitsPerPage);
        boolean nextEnabled = numHits > (this._currentPage + 1) * this._hitsPerPage;
        boolean bl = prevEnabled = this._currentPage > 0;
        if (this._hits == null) {
            return null;
        }
        this.updateProcess(SEARCH_STATUS_SEARCH_END);
        try {
            StringBuffer searchResultXML = new StringBuffer();
            searchResultXML.append("<SearchResult").append(" totalHits=\"").append(numHits).append("\" initPageNum=\"").append(init > 0 ? init + 1 : (numHits < 1 ? 0 : 1)).append("\" maxPageNum=\"").append(max).append("\" hitsPerPage=\"").append(this._hitsPerPage).append("\" nextEnabled=\"").append(nextEnabled).append("\" prevEnabled=\"").append(prevEnabled).append("\" nextText=\"").append(SearchResources.getString((String)"nextActionText")).append("\" prevText=\"").append(SearchResources.getString((String)"previousActionText")).append("\" imagePath=\"").append("./search/images/").append("\" searchString=\"").append(XMLUtil.escape((String)this._queryString)).append("\">");
            int i = init;
            while (i < max) {
                String strSummary;
                String strTitle;
                Document doc = this._hits.doc(i);
                Field url = doc.getField("url");
                Field title = doc.getField("title");
                Field summary = doc.getField("summary");
                Field umaType = doc.getField("uma.type");
                searchResultXML.append("<SearchHit");
                if (url != null) {
                    StringBuffer bufferURL = new StringBuffer();
                    String strUrl = url.stringValue();
                    if (strUrl != null) {
                        bufferURL.append(".").append(strUrl.substring(strUrl.indexOf(_siteFolderName) + _siteFolderName.length()));
                        strUrl = UNCUtil.convertFilenameToUNC((String)bufferURL.toString());
                        searchResultXML.append(" url=\"").append(XMLUtil.escape((String)strUrl)).append("\"");
                    }
                }
                if (title != null && (strTitle = title.stringValue()) != null) {
                    strTitle = XMLUtil.escape((String)strTitle);
                    searchResultXML.append(" title=\"").append(strTitle).append("\"");
                }
                if (summary != null && (strSummary = summary.stringValue()) != null) {
                    strSummary = XMLUtil.escape((String)strSummary);
                    searchResultXML.append(" summary=\"").append(strSummary).append("\"");
                }
                if (umaType != null) {
                    String strUmaType = this.getImageNameFromUmaTypeStr(umaType.stringValue());
                    if (strUmaType.equalsIgnoreCase("General_content")) {
                        searchResultXML.append(" icon=\"").append("Other.gif").append("\"");
                    } else if (strUmaType.equalsIgnoreCase("udt")) {
                        Field shapeImage = doc.getField("searchicon");
                        if (shapeImage != null) {
                            String si = shapeImage.stringValue();
                            if (si != null) {
                                String searchIcon = "./../../" + si;
                                searchResultXML.append(" icon=\"").append(searchIcon).append("\"");
                            }
                        } else {
                            searchResultXML.append(" icon=\"").append("Other.gif").append("\"");
                        }
                    } else {
                        strUmaType = XMLUtil.escape((String)strUmaType);
                        searchResultXML.append(" icon=\"").append(strUmaType).append(".gif").append("\"");
                    }
                }
                searchResultXML.append("/>");
                ++i;
            }
            searchResultXML.append("</SearchResult>");
            System.out.println("Finish:searchResult convert to XML");
            StringWriter result = new StringWriter();
            URL resourceUrl = new URL(String.valueOf(_xslURLEncode) + "search_result.xsl");
            StreamSource xslSource = new StreamSource(resourceUrl.openStream());
            xslSource.setSystemId(new File(String.valueOf(_xslURL) + "search_result.xsl"));
            byte[] xml = searchResultXML.toString().getBytes("utf-8");
            ByteArrayInputStream xmlInput = new ByteArrayInputStream(xml);
            StreamSource xmlSource = new StreamSource(xmlInput);
            XSLTProcessor.transform((Source)xslSource, (Source)xmlSource, (Writer)result, (Properties)this.xslParams, null);
            return SearchApplet.decodeUrlsInContent(result.getBuffer().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_HTML;
        }
    }

    private String getPageResult(boolean isNext) {
        this._currentPage = isNext ? ++this._currentPage : --this._currentPage;
        String result = this.updateOutput(true);
        return result == null ? EMPTY_HTML : result;
    }

    public String getNextPageResult() {
        try {
            String searchResultHTML = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return SearchApplet.this.getPageResult(true);
                }
            });
            return searchResultHTML;
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_HTML;
        }
    }

    public String getPrevPageResult() {
        try {
            String searchResultHTML = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return SearchApplet.this.getPageResult(false);
                }
            });
            return searchResultHTML;
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_HTML;
        }
    }

    private String getImageNameFromUmaTypeStr(String umaTypeStr) {
        String[] imageNamesForSearchResult = new String[]{"Activity", "Artifact", "CapabilityPattern", "Checklist", "Concept", "CustomCategory", "Deliverable", "DeliveryProcess", "Discipline", "DisciplineGrouping", "Domain", "EstimationConsiderations", "Example", "Guideline", "Iteration", "Milestone", "Outcome", "Phase", "Practice", "Report", "ReusableAsset", "Roadmap", "Role", "RoleDescriptor", "RoleSet", "RoleSetGrouping", "Summary", "SupportingMaterial", "Task", "TaskDescriptor", "Template", "TermDefinition", "Tool", "Toolmentor", "Whitepaper", "WorkProductDescriptor", "WorkProductType"};
        int i = 0;
        while (i < imageNamesForSearchResult.length) {
            if (umaTypeStr.equalsIgnoreCase(imageNamesForSearchResult[i])) {
                return imageNamesForSearchResult[i];
            }
            ++i;
        }
        return umaTypeStr;
    }
}

