/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.search.utils;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import org.eclipse.epf.web.search.utils.NetUtil;
import org.eclipse.epf.web.search.utils.StrUtil;

public class FileUtil {
    public static final String LINE_SEP = System.getProperty("line.separator");

    private FileUtil() {
    }

    public static String getAbsolutePath(File file) {
        return file.getAbsolutePath().replace('\\', '/');
    }

    public static String getAbsolutePath(String file) {
        return FileUtil.getAbsolutePath(new File(file));
    }

    public static String getAbsolutePath(URL url) {
        String pathName = url.getFile().substring(1);
        String result = NetUtil.decodeUrl(pathName, null);
        return result;
    }

    public static String getParentDirectory(String path) {
        return new File(path).getParent();
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(path, true);
    }

    public static String getFileName(String path, boolean withExtension) {
        String normalizedPath = path.replace('\\', '/');
        int prefixLength = 0;
        if (normalizedPath.startsWith("file:/")) {
            prefixLength = NetUtil.URI_FILE_PREFIX_SIZE;
        } else if (normalizedPath.startsWith("http://")) {
            prefixLength = NetUtil.URI_HTTP_PREFIX_SIZE;
        }
        int index = normalizedPath.lastIndexOf("/");
        String fileName = index < prefixLength ? normalizedPath.substring(prefixLength) : path.substring(index + 1);
        if (withExtension) {
            return fileName;
        }
        index = fileName.indexOf(".");
        return index > 0 ? fileName.substring(0, index) : fileName;
    }

    public static String appendSeparator(String path) {
        return FileUtil.appendSeparator(path, File.separator);
    }

    public static String appendSeparator(String path, String separator) {
        return path.endsWith(separator) ? path : String.valueOf(path) + separator;
    }

    public static String removeSeparator(String path) {
        return path.endsWith(File.separator) ? path.substring(0, path.length() - 1) : path;
    }

    public static String removeAllSeparator(String path) {
        return path.endsWith("/") || path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
    }

    public static String removeSeparator(String path, String separator) {
        return path.endsWith(separator) ? path.substring(0, path.length() - 1) : path;
    }

    public static String replaceFileName(String path, String oldFileName, String newFileName) {
        int index = path.lastIndexOf(oldFileName);
        return String.valueOf(path.substring(0, index)) + newFileName;
    }

    public static String replaceExtension(String path, String oldExt, String newExt) {
        int index = path.lastIndexOf(oldExt);
        return String.valueOf(path.substring(0, index)) + newExt;
    }

    public static String getLocalePath(String path, String localeStr) {
        if (StrUtil.isBlank(localeStr)) {
            return path;
        }
        String fileName = FileUtil.getFileName(path);
        return FileUtil.replaceFileName(path, fileName, String.valueOf(localeStr) + "/" + fileName);
    }

    public static String getLocalePath(String path, ULocale locale) {
        return locale == null ? path : FileUtil.getLocalePath(path, locale.toString());
    }

    public static boolean writeFile(String filename, String text) {
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(filename);
                writer.write(text);
                writer.flush();
            }
            catch (IOException iOException) {
                if (writer != null) {
                    try {
                        writer.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean writeUTF8File(String filename, String text) {
        OutputStreamWriter writer = null;
        FileOutputStream fileOut = null;
        try {
            try {
                fileOut = new FileOutputStream(filename);
                writer = new OutputStreamWriter((OutputStream)fileOut, "UTF-8");
                writer.write(text);
                writer.flush();
                fileOut.flush();
            }
            catch (IOException iOException) {
                if (writer != null) {
                    try {
                        writer.close();
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fileOut != null) {
                    try {
                        fileOut.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    return true;
                }
                catch (Exception exception) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static void writeFile(String uri, OutputStream output) throws IOException {
        if (uri == null) {
            return;
        }
        InputStream input = null;
        try {
            int bytesRead;
            input = NetUtil.getInputStream(uri);
            byte[] buf = new byte[4096];
            while ((bytesRead = input.read(buf, 0, 4096)) > 0) {
                output.write(buf, 0, bytesRead);
            }
            output.flush();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeFile(String uri, PrintWriter pw) throws IOException {
        if (uri == null) {
            return;
        }
        InputStreamReader input = null;
        try {
            int charsRead;
            input = new InputStreamReader(NetUtil.getInputStream(uri));
            char[] buf = new char[4096];
            while ((charsRead = input.read(buf, 0, 4096)) > 0) {
                pw.write(buf, 0, charsRead);
            }
            pw.flush();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void delete(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    file.delete();
                } else {
                    FileUtil.delete(file);
                }
                ++i;
            }
        }
        dir.delete();
    }
}

