/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.search.utils;

import com.ibm.icu.util.StringTokenizer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epf.web.search.utils.FileUtil;

public class StrUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StrUtil() {
    }

    public static boolean isNull(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isAscii(String str) {
        int len = str == null ? 0 : str.length();
        int i = 0;
        while (i < len) {
            if (str.charAt(i) > '~') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String removeWhiteSpaceChars(String str) {
        int len = str == null ? 0 : str.length();
        int i = 0;
        while (i < len) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    return str;
                }
            }
            ++i;
        }
        return "";
    }

    public static String removeEndOfLineChars(String str) {
        if (StrUtil.isNull(str)) {
            return str;
        }
        String lineSep = FileUtil.LINE_SEP;
        int lineSepSize = FileUtil.LINE_SEP.length();
        while (str.endsWith(lineSep)) {
            str = str.substring(0, str.length() - lineSepSize);
        }
        return str;
    }

    public static String removeChars(String str, String chars) {
        if (StrUtil.isNull(str)) {
            return str;
        }
        int sizeOfChars = chars.length();
        while (str.startsWith(chars)) {
            str = str.substring(sizeOfChars);
        }
        while (str.endsWith(chars)) {
            str = str.substring(0, str.length() - sizeOfChars);
        }
        return str;
    }

    public static String[] split(String str, String sep, int count) {
        if (str == null || count == 0 || count < -1) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(str, sep, count != -1);
        if (count == -1) {
            count = tok.countTokens();
        }
        String[] result = new String[count];
        int i = 0;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            if (i < count) {
                if (t.length() == 1 && sep.indexOf(t) != -1) continue;
                result[i++] = t;
                continue;
            }
            int n = count - 1;
            result[n] = String.valueOf(result[n]) + t;
        }
        return result;
    }

    public static String[] split(String str, String sep) {
        return StrUtil.split(str, sep, -1);
    }

    public static boolean contains(String str, String strSep, String substr) {
        if (str == null || strSep == null || substr == null) {
            return false;
        }
        String[] strs = StrUtil.split(str, strSep, -1);
        if (strs != null) {
            int i = 0;
            while (i < strs.length) {
                if (strs[i] != null && strs[i].equals(substr)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean contains(String str, String strSep, String substr, String subStrSep) {
        if (str == null || strSep == null || substr == null || subStrSep == null) {
            return false;
        }
        String[] strs = StrUtil.split(str, strSep, -1);
        String[] substrs = StrUtil.split(substr, subStrSep, -1);
        if (strs != null && substrs != null) {
            int i = 0;
            while (i < strs.length) {
                if (strs[i] != null) {
                    int j = 0;
                    while (j < substrs.length) {
                        if (substrs[j] != null && substrs[j].equals(strs[i])) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String replace(String str, String src, String tgt) {
        int index;
        if (StrUtil.isNull(str) || StrUtil.isNull(src)) {
            return str;
        }
        String tmpStr = str;
        while ((index = tmpStr.indexOf(src)) != -1) {
            tmpStr = String.valueOf(tmpStr.substring(0, index)) + tgt + tmpStr.substring(index + src.length());
        }
        return tmpStr;
    }

    public static String convert(String str, char ch) {
        if (StrUtil.isNull(str)) {
            return str;
        }
        int len = str.length();
        StringBuffer buf = new StringBuffer(len + 1);
        int i = 0;
        while (i < len) {
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public static String replace(String str, String srcChars, char tgtChar) {
        int i = 0;
        while (i < srcChars.length()) {
            str = str.replace(srcChars.charAt(i), tgtChar);
            ++i;
        }
        return str;
    }

    public static int getIntValue(String str, int defValue) {
        if (StrUtil.isBlank(str)) {
            return defValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static byte[] getUTF8Bytes(String str) {
        char[] c = str.toCharArray();
        int len = c.length;
        int count = 0;
        int i = 0;
        while (i < len) {
            char ch = c[i];
            count = ch <= '\u007f' ? ++count : (ch <= '\u07ff' ? (count += 2) : (count += 3));
            ++i;
        }
        byte[] b = new byte[count];
        int off = 0;
        int i2 = 0;
        while (i2 < len) {
            char ch = c[i2];
            if (ch <= '\u007f') {
                b[off++] = (byte)ch;
            } else if (ch <= '\u07ff') {
                b[off++] = (byte)(ch >> 6 | 0xC0);
                b[off++] = (byte)(ch & 0x3F | 0x80);
            } else {
                b[off++] = (byte)(ch >> 12 | 0xE0);
                b[off++] = (byte)(ch >> 6 & 0x3F | 0x80);
                b[off++] = (byte)(ch & 0x3F | 0x80);
            }
            ++i2;
        }
        return b;
    }

    private static char toHex(int value) {
        return HEX_DIGITS[value & 0xF];
    }

    public static String toEscapedUnicode(String str, boolean skipAscii) {
        int len = str.length();
        StringBuffer result = new StringBuffer(len * 2);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            if (skipAscii && ch < '~') {
                result.append(ch);
            } else {
                result.append("\\u");
                result.append(StrUtil.toHex(ch >> 12 & 0xF));
                result.append(StrUtil.toHex(ch >> 8 & 0xF));
                result.append(StrUtil.toHex(ch >> 4 & 0xF));
                result.append(StrUtil.toHex(ch & 0xF));
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] convertListToStrArray(List list) {
        if (list != null) {
            int cnt = list.size();
            String[] strArray = new String[cnt];
            int i = 0;
            while (i < cnt) {
                String str = (String)list.get(i);
                strArray[i] = new String(str);
                ++i;
            }
            return strArray;
        }
        return null;
    }

    public static String convertFirstLetterCase(String s, String[] keyWords) {
        LinkedList<String> newKeyWordList = new LinkedList<String>();
        int i = 0;
        while (i < keyWords.length) {
            ListIterator iter = newKeyWordList.listIterator();
            int index = 0;
            while (iter.hasNext()) {
                String keyWord = (String)iter.next();
                if (keyWord.toLowerCase().indexOf(keyWords[i].toLowerCase()) >= 0) break;
                ++index;
            }
            newKeyWordList.add(index, keyWords[i]);
            ++i;
        }
        keyWords = newKeyWordList.toArray(new String[0]);
        StringBuffer sb = new StringBuffer(String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase());
        int i2 = 0;
        while (i2 < keyWords.length) {
            int foundIndex = s.indexOf(keyWords[i2].toLowerCase(), 1);
            if (foundIndex != -1) {
                sb.replace(foundIndex, foundIndex + keyWords[i2].length(), keyWords[i2]);
            }
            ++i2;
        }
        return sb.toString();
    }
}

